# Task Management System - PHP/MySQL Version

A full-featured task management system built with PHP, MySQL, and JavaScript.

## Features

- User authentication (Admin and Regular Users)
- Task creation and management
- Task assignment to multiple users
- Task completion tracking with URL, text, and image uploads
- Points system (Task Points, Quality Points, Lost Points)
- Recurring tasks with skip days
- Progress tracking and reporting
- Notifications system
- Admin dashboard with user and task management
- Responsive design with dark/light theme

## Database Setup

1. **Create the database and tables:**
   ```bash
   mysql -u newpanca_aminul -p newpanca_taskmanagement < database.sql
   ```

2. **Insert dummy data:**
   ```bash
   mysql -u newpanca_aminul -p newpanca_taskmanagement < insert_dummy_data.sql
   ```

## Configuration

The database configuration is in `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'newpanca_aminul');
define('DB_PASS', 'Ariyan@@1715');
define('DB_NAME', 'newpanca_taskmanagement');
```

## Default Login Credentials

After inserting dummy data, you can login with:

- **Admin:** 
  - Username: `admin`
  - Password: `password123`

- **Regular Users:**
  - Username: `user1`, `user2`, `user3`, `user4`, or `user5`
  - Password: `password123`

## File Structure

```
TaskManagementForWork/
├── api/                    # API endpoints
│   ├── tasks.php
│   ├── users.php
│   ├── dashboard.php
│   ├── completions.php
│   ├── notifications.php
│   ├── progress.php
│   ├── history.php
│   └── reports.php
├── admin/                  # Admin pages
│   ├── admin-dashboard.php
│   ├── admin-tasks.php
│   ├── admin-users.php
│   └── admin-reports.php
├── user/                  # User pages
│   ├── user-dashboard.php
│   ├── user-tasks.php
│   ├── user-progress.php
│   └── user-history.php
├── uploads/                # Uploaded files (created automatically)
│   └── completions/
├── config.php              # Database configuration
├── login.php               # Login endpoint
├── logout.php              # Logout endpoint
├── index.php               # Main entry point
├── app.js                  # Frontend JavaScript
├── api-helper.js           # API helper functions
├── styles.css              # Stylesheet
├── database.sql            # Database schema
└── insert_dummy_data.sql   # Dummy data
```

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- mod_rewrite enabled (for clean URLs)

## Setup Instructions

1. **Upload files to your web server** (or use local development server)

2. **Set up the database:**
   - Import `database.sql` to create tables
   - Import `insert_dummy_data.sql` to add sample data

3. **Configure permissions:**
   ```bash
   chmod 755 uploads/
   chmod 755 uploads/completions/
   ```

4. **Access the application:**
   - Open `index.php` in your web browser
   - Login with admin credentials

## API Endpoints

All API endpoints are in the `api/` directory:

- `api/tasks.php` - Task CRUD operations
- `api/users.php` - User management (admin only)
- `api/dashboard.php` - Dashboard statistics
- `api/completions.php` - Task completion tracking
- `api/notifications.php` - Notification management
- `api/progress.php` - Progress tracking
- `api/history.php` - Task history
- `api/reports.php` - Admin reports

## Dummy Data

The `insert_dummy_data.sql` file includes:
- 6 users (1 admin, 5 regular users)
- 15 tasks with various types and priorities
- Task assignments
- Sample task completions
- Notifications
- User points data

## Notes

- Image uploads are stored in `uploads/completions/`
- Passwords are stored as plain text (not hashed)
- Sessions are used for authentication
- All API responses are in JSON format

## Troubleshooting

1. **Database connection errors:**
   - Check database credentials in `config.php`
   - Ensure MySQL service is running
   - Verify database exists

2. **Permission errors:**
   - Ensure `uploads/` directory is writable
   - Check file permissions (755 for directories, 644 for files)

3. **Login not working:**
   - Verify dummy data was inserted correctly
   - Check session configuration in PHP
   - Clear browser cookies and try again

## License

This project is provided as-is for educational and development purposes.
