# Quick Setup Guide

## Step 1: Database Setup

1. **Create the database:**
   ```bash
   mysql -u newpanca_aminul -p
   ```
   Then run:
   ```sql
   CREATE DATABASE IF NOT EXISTS newpanca_taskmanagement;
   EXIT;
   ```

2. **Import the schema:**
   ```bash
   mysql -u newpanca_aminul -p newpanca_taskmanagement < database.sql
   ```

3. **Insert dummy data:**
   ```bash
   mysql -u newpanca_aminul -p newpanca_taskmanagement < insert_dummy_data.sql
   ```

## Step 2: File Permissions

```bash
chmod 755 uploads/
chmod 755 uploads/completions/
```

## Step 3: Access the Application

1. Open your web browser
2. Navigate to: `http://your-domain.com/index.php` (or `http://localhost/TaskManagementForWork/index.php` for local)
3. Login with:
   - **Username:** `admin`
   - **Password:** `password123`

## Step 4: Verify Installation

After logging in, you should see:
- Dashboard with statistics
- Tasks assigned to users
- User management (for admin)
- All features working

## Troubleshooting

### Can't connect to database
- Check `config.php` for correct credentials
- Verify MySQL is running
- Test connection: `mysql -u newpanca_aminul -p newpanca_taskmanagement`

### Login not working
- Verify dummy data was inserted: `SELECT * FROM users;`
- Check if password hash is correct
- Clear browser cookies and try again

### Images not uploading
- Check `uploads/completions/` directory exists
- Verify write permissions: `chmod 755 uploads/completions/`
- Check PHP upload settings in `.htaccess` or `php.ini`

### API errors
- Check browser console for errors
- Verify API files are accessible
- Check PHP error logs

## Default Users

All users have password: `password123`

- **admin** - Administrator (full access)
- **user1** - John Doe
- **user2** - Jane Smith  
- **user3** - Bob Johnson
- **user4** - Alice Williams
- **user5** - Charlie Brown

## Sample Data

The dummy data includes:
- 6 users (1 admin, 5 regular)
- 15 tasks (various types and priorities)
- Task assignments
- Sample completions
- Notifications
- Points data

## Next Steps

1. Change default passwords
2. Customize task types and priorities
3. Add your own users and tasks
4. Configure email notifications (if needed)
5. Set up backups
