<?php
require_once 'config.php';

if (!isLoggedIn() || !isAdmin()) {
    header('Location: index.php?error=' . urlencode('Unauthorized'));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php?error=' . urlencode('Method not allowed'));
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    header('Location: index.php?user_error=' . urlencode('Database connection failed'));
    exit;
}

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$role = $_POST['role'] ?? 'user';
$email = $_POST['email'] ?? null;
$full_name = $_POST['full_name'] ?? null;

if (empty($username) || empty($password)) {
    header('Location: index.php?user_error=' . urlencode('Username and password are required'));
    exit;
}

// Check if username exists
$check_stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
$check_stmt->bind_param("s", $username);
$check_stmt->execute();
if ($check_stmt->get_result()->num_rows > 0) {
    header('Location: index.php?user_error=' . urlencode('Username already exists'));
    exit;
}

$stmt = $conn->prepare("
    INSERT INTO users (username, password, role, email, full_name)
    VALUES (?, ?, ?, ?, ?)
");
$stmt->bind_param("sssss", $username, $password, $role, $email, $full_name);

if ($stmt->execute()) {
    $user_id = $conn->insert_id;
    
    // Initialize user points
    $points_stmt = $conn->prepare("INSERT INTO user_points (user_id) VALUES (?)");
    $points_stmt->bind_param("i", $user_id);
    $points_stmt->execute();
    
    header('Location: index.php?success=' . urlencode('User created successfully!') . '#admin-users');
    exit;
} else {
    header('Location: index.php?user_error=' . urlencode('Failed to create user'));
    exit;
}

$conn->close();
?>
