<?php
require_once '../config.php';

if (!isLoggedIn() || !isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    die("Database connection failed. Please check your configuration.");
}

// Get admin stats
$result = $conn->query("SELECT COUNT(*) as count FROM users WHERE role = 'user'");
$total_users = $result->fetch_assoc()['count'];

$result = $conn->query("SELECT COUNT(*) as count FROM tasks");
$total_tasks = $result->fetch_assoc()['count'];

$result = $conn->query("
    SELECT COUNT(DISTINCT t.id) as count
    FROM tasks t
    WHERE t.id NOT IN (
        SELECT DISTINCT task_id 
        FROM task_completions 
        WHERE status = 'completed'
    )
");
$active_tasks = $result->fetch_assoc()['count'];

$result = $conn->query("SELECT COUNT(*) as count FROM task_completions WHERE status = 'completed'");
$completed_tasks = $result->fetch_assoc()['count'];

// Get users
$users_result = $conn->query("
    SELECT u.*, 
           COUNT(DISTINCT CASE WHEN tc.status = 'completed' THEN tc.id END) as tasks_completed,
           COUNT(DISTINCT CASE WHEN ta.task_id IS NOT NULL AND tc.id IS NULL THEN ta.task_id END) as tasks_pending
    FROM users u
    LEFT JOIN task_assignments ta ON u.id = ta.user_id
    LEFT JOIN task_completions tc ON ta.task_id = tc.task_id AND ta.user_id = tc.user_id AND tc.status = 'completed'
    WHERE u.role = 'user'
    GROUP BY u.id
    ORDER BY u.username
");
$users = [];
while ($row = $users_result->fetch_assoc()) {
    $users[] = $row;
}

// Get user performance
$performance_result = $conn->query("
    SELECT u.id, u.username, u.full_name,
           COUNT(DISTINCT CASE WHEN tc.status = 'completed' THEN tc.id END) as tasks_completed,
           COUNT(DISTINCT CASE WHEN ta.task_id IS NOT NULL AND tc.id IS NULL THEN ta.task_id END) as tasks_pending,
           COALESCE(up.total_task_points, 0) + COALESCE(up.total_quality_points, 0) as total_points,
           COALESCE(up.total_task_points, 0) as task_points,
           COALESCE(up.total_quality_points, 0) as quality_points
    FROM users u
    LEFT JOIN task_assignments ta ON u.id = ta.user_id
    LEFT JOIN task_completions tc ON ta.task_id = tc.task_id AND ta.user_id = tc.user_id AND tc.status = 'completed'
    LEFT JOIN user_points up ON u.id = up.user_id
    WHERE u.role = 'user'
    GROUP BY u.id
    ORDER BY tasks_completed DESC
");
$performance = [];
while ($row = $performance_result->fetch_assoc()) {
    $total = $row['tasks_completed'] + $row['tasks_pending'];
    $row['completion_rate'] = $total > 0 ? round(($row['tasks_completed'] / $total) * 100, 1) : 0;
    $performance[] = $row;
}

function escapeHtml($text) {
    return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}
?>

<div class="page-header">
    <h1>Admin Dashboard</h1>
</div>
<div class="admin-stats-grid">
    <div class="admin-stat-card">
        <h3>Total Users</h3>
        <p><?php echo $total_users; ?></p>
    </div>
    <div class="admin-stat-card">
        <h3>Total Tasks</h3>
        <p><?php echo $total_tasks; ?></p>
    </div>
    <div class="admin-stat-card">
        <h3>Active Tasks</h3>
        <p><?php echo $active_tasks; ?></p>
    </div>
    <div class="admin-stat-card">
        <h3>Completed Tasks</h3>
        <p><?php echo $completed_tasks; ?></p>
    </div>
</div>
<div class="admin-sections">
    <div class="admin-section-card">
        <h2>User Performance</h2>
        <div class="performance-list">
            <?php if (empty($performance)): ?>
                <div class="empty-state">
                    <div class="empty-state-icon">📊</div>
                    <h3>No performance data</h3>
                </div>
            <?php else: ?>
                <?php foreach ($performance as $user): ?>
                    <div class="performance-item">
                        <div class="performance-info">
                            <h4><?php echo escapeHtml($user['full_name'] ?? $user['username']); ?></h4>
                            <p><?php echo $user['tasks_completed'] ?? 0; ?> completed, <?php echo $user['tasks_pending'] ?? 0; ?> pending</p>
                        </div>
                        <div class="performance-stats">
                            <div class="stat-value"><?php echo $user['completion_rate']; ?>%</div>
                            <div class="stat-label">Completion Rate</div>
                            <div class="stat-value" style="margin-top: 5px;"><?php echo $user['total_points'] ?? 0; ?></div>
                            <div class="stat-label">Total Points</div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
