<?php
require_once '../config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$conn = getDBConnection();
$method = $_SERVER['REQUEST_METHOD'];
$user_id = getCurrentUserId();

switch ($method) {
    case 'GET':
        // Get notifications
        $unread_only = $_GET['unread_only'] ?? false;
        
        $query = "SELECT * FROM notifications WHERE user_id = ?";
        $params = [$user_id];
        $types = 'i';
        
        if ($unread_only) {
            $query .= " AND is_read = 0";
        }
        
        $query .= " ORDER BY created_at DESC LIMIT 50";
        
        $stmt = $conn->prepare($query);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $notifications = [];
        while ($row = $result->fetch_assoc()) {
            $notifications[] = $row;
        }
        
        // Get unread count
        $count_stmt = $conn->prepare("SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0");
        $count_stmt->bind_param("i", $user_id);
        $count_stmt->execute();
        $count_result = $count_stmt->get_result();
        $unread_count = $count_result->fetch_assoc()['count'];
        
        echo json_encode([
            'success' => true, 
            'notifications' => $notifications,
            'unread_count' => $unread_count
        ]);
        break;
        
    case 'PUT':
        // Mark notification as read or clear all
        $data = json_decode(file_get_contents('php://input'), true);
        $action = $data['action'] ?? 'read';
        
        if ($action === 'clear_all') {
            $stmt = $conn->prepare("DELETE FROM notifications WHERE user_id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            echo json_encode(['success' => true, 'message' => 'All notifications cleared']);
        } else {
            $notification_id = $data['id'] ?? null;
            if ($notification_id) {
                $stmt = $conn->prepare("UPDATE notifications SET is_read = 1 WHERE id = ? AND user_id = ?");
                $stmt->bind_param("ii", $notification_id, $user_id);
                $stmt->execute();
                echo json_encode(['success' => true, 'message' => 'Notification marked as read']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Notification ID is required']);
            }
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Method not allowed']);
}

$conn->close();
?>
