# Fix for Blank Page After Login

## Issue
After login, the page shows blank and appears to hang.

## Root Causes & Solutions

### 1. Dashboard Page Not Loading
**Problem:** The dashboard page (`user/user-dashboard.php`) is not being loaded automatically.

**Solution:** The code now automatically loads the dashboard after login. Check browser console for:
- "User is logged in, loading dashboard..."
- "Loading page: dashboard from: user/user-dashboard.php"
- "Page content loaded, initializing features..."

### 2. API Calls Failing
**Problem:** API endpoints are not responding or returning errors.

**Test:** Open browser console and check for:
- Network errors in Network tab
- API errors in Console tab
- CORS errors

**Solution:**
- Verify `api/dashboard.php` is accessible
- Check database connection
- Verify user session is active

### 3. JavaScript Errors
**Problem:** JavaScript errors preventing page from loading.

**Solution:**
- Open browser console (F12)
- Look for red error messages
- Check if `api-helper.js` is loaded
- Verify all functions are defined

## Quick Diagnostic Steps

1. **Open Browser Console (F12)**
   - Check for error messages
   - Look for "DOM Content Loaded" message
   - Check if "User is logged in" appears

2. **Check Network Tab**
   - Look for failed requests (red)
   - Check if `user/user-dashboard.php` loads (Status 200)
   - Check if `api/dashboard.php` loads (Status 200)

3. **Test API Directly**
   - After login, open: `http://your-domain/api/dashboard.php`
   - Should return JSON data
   - If you see "Unauthorized", session is not working

4. **Check Session**
   - Open: `http://your-domain/test_api.php`
   - Should show your user info
   - If not, session is not persisting

## Manual Fix

If the page is still blank, try this in browser console:

```javascript
// Manually load dashboard
loadPage('dashboard');

// Or test API
getDashboardStatsAPI().then(console.log).catch(console.error);
```

## Common Fixes

1. **Clear Browser Cache**
   - Hard refresh: Ctrl+Shift+R (Windows) or Cmd+Shift+R (Mac)

2. **Check File Permissions**
   - Ensure PHP files are readable
   - Check `.htaccess` is not blocking

3. **Verify Database**
   - Run `check_setup.php` to verify setup
   - Ensure users and tasks exist

4. **Check PHP Errors**
   - Enable error display temporarily
   - Check PHP error logs

## Expected Behavior

After login, you should see:
1. Page reloads
2. Console shows: "DOM Content Loaded"
3. Console shows: "User is logged in, loading dashboard..."
4. Dashboard page loads
5. Data appears from database

If any step fails, check the console error message.
