# Troubleshooting: Blank Page After Login

## Quick Fixes

### 1. Check Browser Console
Open Developer Tools (F12) and check the Console tab for errors. Common issues:
- API helper not loaded
- CORS errors
- Network errors
- JavaScript errors

### 2. Verify Files Are Loaded
Check Network tab in Developer Tools to ensure:
- `api-helper.js` is loaded (Status 200)
- `app.js` is loaded (Status 200)
- API endpoints are accessible

### 3. Check API Endpoints
Test if API is working:
- Open: `http://your-domain/api/dashboard.php`
- Should return JSON (if logged in) or error message

### 4. Common Issues

#### Issue: "API helper functions not loaded"
**Solution:** 
- Check if `api-helper.js` is in the correct location
- Verify the script tag in `index.php` is correct
- Clear browser cache

#### Issue: CORS Errors
**Solution:**
- Ensure you're accessing via the same domain
- Check `.htaccess` file is not blocking requests

#### Issue: Database Connection Errors
**Solution:**
- Verify database credentials in `config.php`
- Check MySQL service is running
- Test connection: `php check_setup.php`

#### Issue: Session Not Working
**Solution:**
- Check PHP sessions are enabled
- Verify `session_start()` is called in `config.php`
- Clear browser cookies and try again

### 5. Manual Testing

1. **Test Login:**
   ```
   Open: index.php
   Login with: admin/password123
   ```

2. **Check Console:**
   - Should see: "DOM Content Loaded"
   - Should see: "User is logged in, loading dashboard..."
   - Should see: "Loading page: dashboard"

3. **Check Network:**
   - Should see request to `user/user-dashboard.php`
   - Should see request to `api/dashboard.php`

### 6. Debug Steps

1. Add this to browser console:
   ```javascript
   console.log('IS_LOGGED_IN:', IS_LOGGED_IN);
   console.log('CURRENT_USER:', CURRENT_USER);
   console.log('getDashboardStatsAPI:', typeof getDashboardStatsAPI);
   ```

2. Manually trigger dashboard load:
   ```javascript
   loadPage('dashboard');
   ```

3. Test API directly:
   ```javascript
   getDashboardStatsAPI().then(console.log).catch(console.error);
   ```

### 7. If Still Not Working

1. **Check PHP Errors:**
   - Enable error display in `config.php` temporarily
   - Check PHP error logs

2. **Verify Database:**
   - Run `check_setup.php` to verify database setup
   - Ensure dummy data is inserted

3. **Check File Permissions:**
   - Ensure PHP files are readable
   - Check `.htaccess` is not blocking

4. **Test with Simple Page:**
   - Create a test PHP file to verify PHP is working
   - Test database connection separately

## Still Having Issues?

1. Check the browser console for specific error messages
2. Check the Network tab for failed requests
3. Verify all files are uploaded correctly
4. Test API endpoints directly in browser
5. Check server error logs
