<?php
// Quick script to check if disable_reason column exists and show sample data
require_once 'config.php';

$conn = getDBConnection();
if (!$conn) {
    die("Database connection failed.");
}

// Check if column exists
$checkColumn = $conn->query("SHOW COLUMNS FROM tasks LIKE 'disable_reason'");
$columnExists = $checkColumn && $checkColumn->num_rows > 0;

echo "<h2>Disable Reason Column Check</h2>";
echo "<p>Column exists: " . ($columnExists ? "YES" : "NO") . "</p>";

if ($columnExists) {
    // Get a sample disabled task
    $result = $conn->query("
        SELECT id, name, is_enabled, disable_reason 
        FROM tasks 
        WHERE is_enabled = 0 
        LIMIT 5
    ");
    
    echo "<h3>Sample Disabled Tasks:</h3>";
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Name</th><th>is_enabled</th><th>disable_reason</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['id']) . "</td>";
        echo "<td>" . htmlspecialchars($row['name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['is_enabled']) . "</td>";
        echo "<td>" . htmlspecialchars($row['disable_reason'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
} else {
    echo "<p style='color: red;'><strong>Column does not exist! Please run the migration:</strong></p>";
    echo "<pre>ALTER TABLE `tasks` ADD COLUMN `disable_reason` TEXT NULL COMMENT 'Reason for disabling the task' AFTER `is_enabled`;</pre>";
}

$conn->close();
?>
