<?php
// Enable all error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "<h1>Error Check</h1>";

// Test config.php
echo "<h2>1. Testing config.php</h2>";
try {
    require_once 'config.php';
    echo "✓ config.php loaded successfully<br>";
} catch (Exception $e) {
    echo "✗ Error loading config.php: " . $e->getMessage() . "<br>";
    exit;
}

// Test functions
echo "<h2>2. Testing Functions</h2>";
if (function_exists('isLoggedIn')) {
    echo "✓ isLoggedIn() exists<br>";
} else {
    echo "✗ isLoggedIn() not found<br>";
}

if (function_exists('getCurrentUserRole')) {
    echo "✓ getCurrentUserRole() exists<br>";
} else {
    echo "✗ getCurrentUserRole() not found<br>";
}

if (function_exists('getCurrentUsername')) {
    echo "✓ getCurrentUsername() exists<br>";
} else {
    echo "✗ getCurrentUsername() not found<br>";
}

if (function_exists('getDBConnection')) {
    echo "✓ getDBConnection() exists<br>";
} else {
    echo "✗ getDBConnection() not found<br>";
}

// Test database connection
echo "<h2>3. Testing Database Connection</h2>";
try {
    $conn = getDBConnection();
    if ($conn) {
        echo "✓ Database connection successful<br>";
        
        // Test query
        $result = $conn->query("SELECT 1 as test");
        if ($result) {
            echo "✓ Test query successful<br>";
        } else {
            echo "✗ Test query failed: " . $conn->error . "<br>";
        }
    } else {
        echo "✗ Database connection returned null<br>";
    }
} catch (Exception $e) {
    echo "✗ Database connection error: " . $e->getMessage() . "<br>";
}

// Test session
echo "<h2>4. Testing Session</h2>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "✓ Session is active<br>";
    echo "Session ID: " . session_id() . "<br>";
} else {
    echo "✗ Session is not active<br>";
    echo "Session status: " . session_status() . "<br>";
}

// Test index.php syntax
echo "<h2>5. Testing index.php Syntax</h2>";
$syntax_check = shell_exec("php -l index.php 2>&1");
if (strpos($syntax_check, 'No syntax errors') !== false) {
    echo "✓ index.php syntax is valid<br>";
} else {
    echo "✗ index.php syntax error:<br>";
    echo "<pre>" . htmlspecialchars($syntax_check) . "</pre>";
}

// Test PHP version
echo "<h2>6. PHP Information</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Error Reporting: " . error_reporting() . "<br>";
echo "Display Errors: " . ini_get('display_errors') . "<br>";
echo "Log Errors: " . ini_get('log_errors') . "<br>";

// Check for common issues
echo "<h2>7. Common Issues Check</h2>";
if (!file_exists('config.php')) {
    echo "✗ config.php file not found<br>";
} else {
    echo "✓ config.php file exists<br>";
}

if (!file_exists('app-minimal.js')) {
    echo "✗ app-minimal.js file not found<br>";
} else {
    echo "✓ app-minimal.js file exists<br>";
}

// Check permissions
echo "<h2>8. File Permissions</h2>";
$files_to_check = ['index.php', 'config.php', 'app-minimal.js'];
foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "$file: $perms<br>";
    }
}
?>
