<?php
// Simple debug page to check database connection
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Debug Information</h1>";

// Check config
echo "<h2>Config Check</h2>";
require_once 'config.php';
echo "Config loaded<br>";

// Check database connection
echo "<h2>Database Connection</h2>";
$conn = getDBConnection();
if ($conn) {
    echo "✓ Database connection successful<br>";
    echo "Database: " . DB_NAME . "<br>";
    
    // Test query
    $result = $conn->query("SELECT 1 as test");
    if ($result) {
        echo "✓ Test query successful<br>";
    } else {
        echo "✗ Test query failed: " . $conn->error . "<br>";
    }
} else {
    echo "✗ Database connection failed<br>";
    echo "Check your database credentials in config.php<br>";
}

// Check session
echo "<h2>Session Check</h2>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "✓ Session is active<br>";
    echo "Session ID: " . session_id() . "<br>";
    if (isset($_SESSION['user_id'])) {
        echo "User ID: " . $_SESSION['user_id'] . "<br>";
        echo "Username: " . ($_SESSION['username'] ?? 'N/A') . "<br>";
    } else {
        echo "No user logged in<br>";
    }
} else {
    echo "✗ Session is not active<br>";
}

// Check PHP version
echo "<h2>PHP Information</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Error Reporting: " . (error_reporting() ? 'Enabled' : 'Disabled') . "<br>";
?>
