<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Custom error handler
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    error_log("Error [$errno]: $errstr in $errfile on line $errline");
    return false; // Let PHP handle it normally
}

set_error_handler("customErrorHandler");

// Custom exception handler
function customExceptionHandler($exception) {
    error_log("Uncaught exception: " . $exception->getMessage());
    error_log("Stack trace: " . $exception->getTraceAsString());
    http_response_code(500);
    die("An error occurred. Please check the error log.");
}

set_exception_handler("customExceptionHandler");
?>
