<?php
// Simple API test
require_once 'config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in', 'session' => $_SESSION]);
    exit;
}

echo json_encode([
    'success' => true,
    'message' => 'API is working',
    'user' => [
        'id' => getCurrentUserId(),
        'username' => getCurrentUsername(),
        'role' => getCurrentUserRole()
    ],
    'session' => [
        'user_id' => $_SESSION['user_id'] ?? null,
        'username' => $_SESSION['username'] ?? null,
        'role' => $_SESSION['role'] ?? null
    ]
]);
?>
