<?php
// Test script to check database connection and user data
require_once 'config.php';

echo "<h2>Database Connection Test</h2>";

try {
    $conn = getDBConnection();
    echo "<p style='color: green;'>✓ Database connection successful</p>";
    
    // Check if users table exists
    $result = $conn->query("SHOW TABLES LIKE 'users'");
    if ($result->num_rows > 0) {
        echo "<p style='color: green;'>✓ Users table exists</p>";
        
        // Get all users
        $users_result = $conn->query("SELECT id, username, password, role FROM users");
        echo "<h3>Users in database:</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Username</th><th>Password (first 10 chars)</th><th>Role</th></tr>";
        
        while ($user = $users_result->fetch_assoc()) {
            $password_preview = substr($user['password'], 0, 10) . '...';
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            echo "<td>" . htmlspecialchars($password_preview) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Test login with admin
        echo "<h3>Testing login with admin/password123:</h3>";
        $test_stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username = ?");
        $test_username = 'admin';
        $test_password = 'password123';
        $test_stmt->bind_param("s", $test_username);
        $test_stmt->execute();
        $test_result = $test_stmt->get_result();
        
        if ($test_result->num_rows === 1) {
            $test_user = $test_result->fetch_assoc();
            if ($test_password === $test_user['password']) {
                echo "<p style='color: green;'>✓ Password matches for admin</p>";
            } else {
                echo "<p style='color: red;'>✗ Password does NOT match for admin</p>";
                echo "<p>Stored password: '" . htmlspecialchars($test_user['password']) . "'</p>";
                echo "<p>Expected password: 'password123'</p>";
            }
        } else {
            echo "<p style='color: red;'>✗ Admin user not found</p>";
        }
        
    } else {
        echo "<p style='color: red;'>✗ Users table does not exist</p>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
