<?php
// Test session functionality
require_once 'config.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Session Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
    </style>
</head>
<body>
    <h1>Session Test</h1>
    
    <h2>Session Status</h2>
    <p>Session Status: <strong><?php echo session_status() === PHP_SESSION_ACTIVE ? 'Active' : 'Not Active'; ?></strong></p>
    <p>Session ID: <strong><?php echo session_id(); ?></strong></p>
    
    <h2>Session Data</h2>
    <pre><?php print_r($_SESSION); ?></pre>
    
    <h2>Login Check</h2>
    <p>Is Logged In: <strong class="<?php echo isLoggedIn() ? 'success' : 'error'; ?>"><?php echo isLoggedIn() ? 'YES' : 'NO'; ?></strong></p>
    <p>User ID: <strong><?php echo getCurrentUserId() ?? 'null'; ?></strong></p>
    <p>Username: <strong><?php echo getCurrentUsername(); ?></strong></p>
    <p>Role: <strong><?php echo getCurrentUserRole(); ?></strong></p>
    
    <h2>Test Login</h2>
    <form method="POST" action="login.php" id="testLoginForm">
        <p>
            <label>Username: <input type="text" name="username" value="admin"></label>
        </p>
        <p>
            <label>Password: <input type="password" name="password" value="password123"></label>
        </p>
        <p>
            <button type="button" onclick="testLogin()">Test Login (AJAX)</button>
        </p>
    </form>
    <div id="loginResult"></div>
    
    <hr>
    <p><a href="index.php">Go to Main Application</a></p>
    
    <script>
        async function testLogin() {
            const form = document.getElementById('testLoginForm');
            const formData = new FormData(form);
            const username = formData.get('username');
            const password = formData.get('password');
            
            const resultDiv = document.getElementById('loginResult');
            resultDiv.innerHTML = '<p class="info">Testing login...</p>';
            
            try {
                const response = await fetch('login.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ username, password })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    resultDiv.innerHTML = '<p class="success">✓ Login successful! Reloading page...</p>';
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                } else {
                    resultDiv.innerHTML = '<p class="error">✗ Login failed: ' + data.message + '</p>';
                }
            } catch (error) {
                resultDiv.innerHTML = '<p class="error">✗ Error: ' + error.message + '</p>';
            }
        }
    </script>
</body>
</html>
