<?php
error_reporting(E_ALL);
ini_set('display_errors', 0); // Don't display errors, log them instead
ini_set('log_errors', 1);

require_once 'config.php';

if (!isLoggedIn()) {
    // Determine redirect URL based on referer
    $referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    $redirect_url = (strpos($referer, '/user/') !== false || strpos($referer, '/admin/') !== false) 
        ? $referer . '?error=' . urlencode('Please login first')
        : 'index.php?error=' . urlencode('Please login first');
    header('Location: ' . $redirect_url);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // Determine redirect URL based on referer
    $referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    $redirect_url = (strpos($referer, '/user/') !== false || strpos($referer, '/admin/') !== false) 
        ? $referer . '?error=' . urlencode('Method not allowed')
        : 'index.php?error=' . urlencode('Method not allowed');
    header('Location: ' . $redirect_url);
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    error_log("Database connection failed in complete_task.php");
    // Determine redirect URL based on referer
    $referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    $redirect_url = (strpos($referer, '/user/') !== false || strpos($referer, '/admin/') !== false) 
        ? $referer . '?complete_error=' . urlencode('Database connection failed')
        : 'index.php?complete_error=' . urlencode('Database connection failed');
    header('Location: ' . $redirect_url);
    exit;
}

$user_id = getCurrentUserId();
$task_id = $_POST['task_id'] ?? null;
$completion_url = trim($_POST['completion_url'] ?? '');
$completion_text = trim($_POST['completion_text'] ?? '');
$completion_date = date('Y-m-d');
$status = 'completed';

// Determine redirect URL based on referer
$referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
$base_redirect = (strpos($referer, '/user/') !== false || strpos($referer, '/admin/') !== false) 
    ? $referer 
    : 'index.php';

if (!$task_id) {
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Task ID is required'));
    exit;
}

// Allow empty completion fields (URL/Text/Image) for simple task completion

// Check if user is assigned to this task
$check_stmt = $conn->prepare("SELECT * FROM task_assignments WHERE task_id = ? AND user_id = ?");
if (!$check_stmt) {
    error_log("Failed to prepare check statement: " . $conn->error);
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Database error occurred'));
    exit;
}
$check_stmt->bind_param("ii", $task_id, $user_id);
if (!$check_stmt->execute()) {
    error_log("Failed to execute check statement: " . $check_stmt->error);
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Database error occurred'));
    exit;
}
$check_result = $check_stmt->get_result();

if ($check_result->num_rows === 0) {
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('You are not assigned to this task'));
    exit;
}

// Get task details
$task_stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$task_stmt->bind_param("i", $task_id);
$task_stmt->execute();
$task_result = $task_stmt->get_result();
$task = $task_result->fetch_assoc();

if (!$task) {
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Task not found'));
    exit;
}

// Handle image upload
$completion_image = null;
if (isset($_FILES['completion_image']) && $_FILES['completion_image']['error'] === UPLOAD_ERR_OK) {
    $upload_dir = 'uploads/completions/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    $file_ext = pathinfo($_FILES['completion_image']['name'], PATHINFO_EXTENSION);
    $allowed_exts = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array(strtolower($file_ext), $allowed_exts)) {
        header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Invalid file type. Only JPG, PNG, GIF allowed.'));
        exit;
    }
    
    $file_name = 'completion_' . $task_id . '_' . $user_id . '_' . time() . '.' . $file_ext;
    $file_path = $upload_dir . $file_name;
    
    if (move_uploaded_file($_FILES['completion_image']['tmp_name'], $file_path)) {
        $completion_image = $upload_dir . $file_name;
    }
}

// Calculate points
$task_points_earned = $task['task_points'];
$quality_points_earned = $task['quality_points'];
$lost_task_points = 0;

// Prepare values for bind_param (must be variables, not expressions)
$completion_url_value = !empty($completion_url) ? $completion_url : null;
$completion_text_value = !empty($completion_text) ? $completion_text : null;
$completion_image_value = $completion_image ?: null;

$stmt = $conn->prepare("
    INSERT INTO task_completions 
    (task_id, user_id, completion_date, completion_url, completion_text, 
     completion_image, status, task_points_earned, quality_points_earned, lost_task_points)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    error_log("Failed to prepare insert statement: " . $conn->error);
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Database error: ' . $conn->error));
    exit;
}
$stmt->bind_param("iisssssiii", $task_id, $user_id, $completion_date, 
                 $completion_url_value, $completion_text_value, $completion_image_value, 
                 $status, $task_points_earned, $quality_points_earned, $lost_task_points);

if ($stmt->execute()) {
    // If this is a recurring task, update the instance status
    if ($task['task_type'] === 'recurring') {
        // Update recurring task instance status
        $update_instance = $conn->prepare("
            UPDATE recurring_task_instances 
            SET status = ? 
            WHERE parent_task_id = ? AND instance_date = ?
        ");
        if ($update_instance) {
            $update_instance->bind_param("sis", $status, $task_id, $completion_date);
            $update_instance->execute();
        }
    }
    
    // Update user points
    $points_stmt = $conn->prepare("
        INSERT INTO user_points (user_id, total_task_points, total_quality_points, 
                               total_lost_task_points)
        VALUES (?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
        total_task_points = total_task_points + VALUES(total_task_points),
        total_quality_points = total_quality_points + VALUES(total_quality_points),
        total_lost_task_points = total_lost_task_points + VALUES(total_lost_task_points)
    ");
    if ($points_stmt) {
        $points_stmt->bind_param("iiii", $user_id, $task_points_earned, $quality_points_earned, $lost_task_points);
        $points_stmt->execute();
    }
    
    header('Location: ' . $base_redirect . '?success=' . urlencode('Task marked as complete successfully!'));
    exit;
} else {
    error_log("Failed to execute insert statement: " . $stmt->error);
    header('Location: ' . $base_redirect . '?complete_error=' . urlencode('Failed to mark task as complete: ' . $stmt->error));
    exit;
}

$conn->close();
?>
