# Cronjob Setup for Recurring Tasks

## What the Cronjob Does

The `cronjob.php` script automatically processes recurring tasks and:
- Checks for recurring tasks that need to be scheduled
- Updates task start dates based on recurring intervals
- Creates notifications for users when recurring tasks are due
- Skips days that are configured in the task's skip_days field

## Setup Instructions

### Option 1: Using cPanel Cron Jobs

1. Log into your cPanel
2. Navigate to **Cron Jobs**
3. Add a new cron job with:
   - **Minute:** 0
   - **Hour:** 0 (or any hour you prefer)
   - **Day:** *
   - **Month:** *
   - **Weekday:** *
   - **Command:** `/usr/bin/php /home/yourusername/public_html/TaskManagementForWork/cronjob.php`
   
   Or for hourly execution:
   - **Minute:** 0
   - **Hour:** *
   - **Command:** `/usr/bin/php /home/yourusername/public_html/TaskManagementForWork/cronjob.php`

### Option 2: Using SSH/Command Line

1. SSH into your server
2. Edit crontab:
   ```bash
   crontab -e
   ```

3. Add one of these lines:

   **Run daily at midnight:**
   ```
   0 0 * * * /usr/bin/php /path/to/TaskManagementForWork/cronjob.php
   ```

   **Run every hour:**
   ```
   0 * * * * /usr/bin/php /path/to/TaskManagementForWork/cronjob.php
   ```

   **Run every 6 hours:**
   ```
   0 */6 * * * /usr/bin/php /path/to/TaskManagementForWork/cronjob.php
   ```

4. Save and exit (in vi: press `Esc`, type `:wq`, press Enter)

### Option 3: Manual Testing

You can test the cronjob manually by running:
```bash
php /path/to/TaskManagementForWork/cronjob.php
```

## Verify Cronjob is Working

1. Check the log file: `cronjob.log` in your project directory
2. The log will show:
   - When the cronjob ran
   - How many tasks were processed
   - Any errors that occurred

## Log File Location

The cronjob creates a log file at:
```
/path/to/TaskManagementForWork/cronjob.log
```

You can view recent logs:
```bash
tail -f /path/to/TaskManagementForWork/cronjob.log
```

## Troubleshooting

### Cronjob not running
- Check if PHP path is correct: `which php`
- Check file permissions: `chmod 755 cronjob.php`
- Check cron service is running: `service cron status`

### Permission errors
- Ensure the log file is writable: `chmod 666 cronjob.log`
- Or create it first: `touch cronjob.log && chmod 666 cronjob.log`

### Database connection errors
- Verify database credentials in `config.php`
- Check if database server is accessible from cron context

## Recommended Schedule

- **For daily recurring tasks:** Run once per day at midnight (0 0 * * *)
- **For tasks with shorter intervals:** Run every hour (0 * * * *)
- **For testing:** Run every 15 minutes (*/15 * * * *)

## Notes

- The cronjob updates existing tasks rather than creating duplicates
- Tasks with skip_days configured will be skipped on those days
- Notifications are automatically created for assigned users
- The script is designed to be safe to run multiple times per day
