<?php
require_once 'config.php';

if (!isLoggedIn() || !isAdmin()) {
    header('Location: index.php?error=' . urlencode('Unauthorized'));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php?error=' . urlencode('Method not allowed'));
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    header('Location: index.php?error=' . urlencode('Database connection failed'));
    exit;
}

$user_id = getCurrentUserId();
$task_id = intval($_POST['task_id'] ?? 0);
$admin_password = $_POST['admin_password'] ?? '';

if (!$task_id) {
    header('Location: index.php?error=' . urlencode('Task ID is required'));
    exit;
}

// Verify admin password
$admin_stmt = $conn->prepare("SELECT password FROM users WHERE id = ? AND role = 'admin'");
$admin_stmt->bind_param("i", $user_id);
$admin_stmt->execute();
$admin_result = $admin_stmt->get_result();
$admin = $admin_result->fetch_assoc();

if (!$admin || $admin_password !== $admin['password']) {
    header('Location: index.php?error=' . urlencode('Invalid admin password'));
    exit;
}

$stmt = $conn->prepare("DELETE FROM tasks WHERE id = ?");
$stmt->bind_param("i", $task_id);

if ($stmt->execute()) {
    header('Location: index.php?success=' . urlencode('Task deleted successfully!') . '#admin-tasks');
    exit;
} else {
    header('Location: index.php?error=' . urlencode('Failed to delete task'));
    exit;
}

$conn->close();
?>
