<?php
require_once 'config.php';

if (!isLoggedIn() || !isAdmin()) {
    header('Location: index.php?error=' . urlencode('Unauthorized'));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php?error=' . urlencode('Method not allowed'));
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    header('Location: index.php?error=' . urlencode('Database connection failed'));
    exit;
}

$current_user_id = getCurrentUserId();
$user_id_to_delete = intval($_POST['user_id'] ?? 0);
$admin_password = $_POST['admin_password'] ?? '';

if (!$user_id_to_delete) {
    header('Location: index.php?error=' . urlencode('User ID is required'));
    exit;
}

// Verify admin password
$admin_stmt = $conn->prepare("SELECT password FROM users WHERE id = ? AND role = 'admin'");
$admin_stmt->bind_param("i", $current_user_id);
$admin_stmt->execute();
$admin_result = $admin_stmt->get_result();
$admin = $admin_result->fetch_assoc();

if (!$admin || $admin_password !== $admin['password']) {
    header('Location: index.php?error=' . urlencode('Invalid admin password'));
    exit;
}

// Prevent deleting the last admin
$users_result = $conn->query("SELECT COUNT(*) as count FROM users WHERE role = 'admin'");
$admin_count = $users_result->fetch_assoc()['count'];
$user_to_delete = $conn->query("SELECT role FROM users WHERE id = $user_id_to_delete")->fetch_assoc();

if ($user_to_delete && $user_to_delete['role'] === 'admin' && $admin_count <= 1) {
    header('Location: index.php?error=' . urlencode('Cannot delete the last admin user'));
    exit;
}

$stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id_to_delete);

if ($stmt->execute()) {
    header('Location: index.php?success=' . urlencode('User deleted successfully!') . '#admin-users');
    exit;
} else {
    header('Location: index.php?error=' . urlencode('Failed to delete user'));
    exit;
}

$conn->close();
?>
