<?php
require_once 'config.php';

if (!isLoggedIn() || !isAdmin()) {
    header('Location: index.php?error=' . urlencode('Unauthorized'));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php?error=' . urlencode('Method not allowed'));
    exit;
}

$conn = getDBConnection();
if (!$conn) {
    header('Location: index.php?user_error=' . urlencode('Database connection failed'));
    exit;
}

$user_id = intval($_POST['user_id'] ?? 0);

if (!$user_id) {
    header('Location: index.php?user_error=' . urlencode('User ID is required'));
    exit;
}

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$role = $_POST['role'] ?? 'user';
$email = $_POST['email'] ?? null;
$full_name = $_POST['full_name'] ?? null;

if (empty($username)) {
    header('Location: index.php?user_error=' . urlencode('Username is required'));
    exit;
}

// Check if username exists (excluding current user)
$check_stmt = $conn->prepare("SELECT id FROM users WHERE username = ? AND id != ?");
$check_stmt->bind_param("si", $username, $user_id);
$check_stmt->execute();
if ($check_stmt->get_result()->num_rows > 0) {
    header('Location: index.php?user_error=' . urlencode('Username already exists'));
    exit;
}

if (!empty($password)) {
    $stmt = $conn->prepare("
        UPDATE users SET username=?, password=?, role=?, email=?, full_name=?
        WHERE id=?
    ");
    $stmt->bind_param("sssssi", $username, $password, $role, $email, $full_name, $user_id);
} else {
    $stmt = $conn->prepare("
        UPDATE users SET username=?, role=?, email=?, full_name=?
        WHERE id=?
    ");
    $stmt->bind_param("ssssi", $username, $role, $email, $full_name, $user_id);
}

if ($stmt->execute()) {
    header('Location: index.php?success=' . urlencode('User updated successfully!') . '#admin-users');
    exit;
} else {
    header('Location: index.php?user_error=' . urlencode('Failed to update user'));
    exit;
}

$conn->close();
?>
