<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php?error=' . urlencode('Method not allowed'));
    exit;
}

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($username) || empty($password)) {
    header('Location: index.php?error=' . urlencode('Username and password are required'));
    exit;
}

try {
    $conn = getDBConnection();
    
    if (!$conn) {
        error_log("Database connection failed in login.php");
        header('Location: index.php?error=' . urlencode('Database connection failed. Please try again later.'));
        exit;
    }
    
    $stmt = $conn->prepare("SELECT id, username, password, role, email, full_name FROM users WHERE username = ?");
    
    if (!$stmt) {
        header('Location: index.php?error=' . urlencode('Database query preparation failed'));
        exit;
    }
    
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        $passwordMatch = ($password === $user['password']);
        
        if ($passwordMatch) {
            // Ensure session is started
            if (session_status() === PHP_SESSION_NONE) {
                session_start();
            }
            
            // Regenerate session ID for security
            session_regenerate_id(true);
            
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['full_name'] = $user['full_name'];
            
            // Redirect to dashboard
            if ($user['role'] === 'admin') {
                header('Location: index.php#admin-dashboard');
            } else {
                // Use clean relative path (login.php is in root, so user/ is correct)
                header('Location: user/user-dashboard.php');
            }
            exit;
        } else {
            header('Location: index.php?error=' . urlencode('Invalid password'));
            exit;
        }
    } else {
        header('Location: index.php?error=' . urlencode('User not found'));
        exit;
    }

    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    header('Location: index.php?error=' . urlencode('Login error: ' . $e->getMessage()));
    exit;
}
?>
